<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Vehicle;
use Illuminate\Http\Request;

class VehicleController extends Controller
{
    public function index()
    {
        $vehicles = Vehicle::latest()->paginate(10);
        return view('admin.vehicles.index', compact('vehicles'));
    }

    public function create()
    {
        return view('admin.vehicles.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'truck_number' => 'required|string|unique:vehicles,truck_number',
            'driver_name' => 'required|string',
        ]);

        Vehicle::create($request->only('truck_number', 'driver_name'));

        return redirect()->route('admin.vehicles.index')->with('success', 'Vehicle Created Successfully!');
    }
}
