<?php

namespace App\Http\Controllers;

use App\Models\Sale;
use Illuminate\Http\Request;
use PDF;

class PublicInvoiceController extends Controller
{
    public function show($token)
    {
        $sale = Sale::where('public_token', $token)
            ->with(['items.product', 'items.packSize', 'customer', 'salesRep', 'vehicle', 'items'])
            ->firstOrFail();

        // Pass 'isPublic' => true to change view logic if needed (e.g., hide admin buttons)
        return view('sales.billing.pdf', compact('sale'))->with(['isPublic' => true]); 
        // Using PDF view as it is clean for public view too. 
        // Or we could create a new 'public_invoice' view which extends standard layout but simplified.
        // For requirement "View Your Invoice", the PDF structure is good.
    }
}
