<?php

namespace App\Http\Controllers\Sales;

use App\Http\Controllers\Controller;
use App\Models\VehicleStock; // Need to verify Model name
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MyStockController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        if (!$user->vehicle_id) {
            return view('sales.stock.no_vehicle'); 
        }

        $stocks = VehicleStock::with(['product', 'product.packSizes'])
            ->where('vehicle_id', $user->vehicle_id)
            ->where('quantity', '>', 0)
            ->get();

        return view('sales.stock.index', compact('stocks', 'user'));
    }
}
