<?php

namespace App\Http\Controllers\Sales;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Payment;
use App\Models\Sale;

class RepDashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        // 1. Collections Mix
        $cashCollected = Payment::where('collected_by', $user->id)->where('method', 'Cash')->sum('amount');
        $chequeCollected = Payment::where('collected_by', $user->id)->where('method', 'Cheque')->sum('amount');

        // 2. Total Outstanding (Due Payments) on Sales made by this Rep
        $mySalesOutstanding = Sale::where('sales_rep_id', $user->id)->sum('balance_due');
        
        // 3. Today's Sales
        $todaySales = Sale::where('sales_rep_id', $user->id)
            ->whereDate('created_at', today())
            ->sum('net_total');

        return view('dashboard', compact('cashCollected', 'chequeCollected', 'mySalesOutstanding', 'todaySales'));
    }
}
