<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Commission extends Model
{
    use HasFactory;

    protected $fillable = [
        'sales_rep_id',
        'sale_id',
        'payment_id',
        'commission_amount',
        'percentage',
        'status',
    ];

    protected $casts = [
        'commission_amount' => 'decimal:2',
        'percentage' => 'decimal:2',
    ];

    public function salesRep()
    {
        return $this->belongsTo(User::class, 'sales_rep_id');
    }

    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }
}
