<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use HasFactory, SoftDeletes;

    protected $appends = ['total_due'];

    protected $fillable = [
        'name',
        'mobile',
        'address',
        'area',
        'gst_number',
        'credit_limit',
        'default_price_level',
        'payment_terms',
        'is_active',
        'sales_rep_id',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'credit_limit' => 'decimal:2',
    ];

    public function salesRep()
    {
        return $this->belongsTo(User::class, 'sales_rep_id');
    }

    public function sales()
    {
        return $this->hasMany(Sale::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function getTotalDueAttribute()
    {
        return $this->sales->sum('balance_due');
    }
}
