<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Loan extends Model
{
    protected $fillable = [
        'user_id',
        'total_amount',
        'monthly_installment',
        'total_installments',
        'paid_installments',
        'paid_amount',
        'remaining_amount',
        'loan_date',
        'start_deduction_date',
        'status',
        'purpose',
        'approved_by',
    ];

    protected $casts = [
        'loan_date' => 'date',
        'start_deduction_date' => 'date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }
}
