<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['name', 'description', 'image', 'base_cost', 'is_active'];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function packSizes()
    {
        return $this->hasMany(ProductPackSize::class);
    }

    public function vehicleStocks()
    {
        return $this->hasMany(VehicleStock::class);
    }

    public function stock()
    {
        return $this->hasOne(Stock::class);
    }
}
