<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductPackSize extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['product_id', 'size_name', 'quantity', 'is_active', 'height', 'width', 'length', 'weight'];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function priceLevels()
    {
        return $this->hasMany(ProductPriceLevel::class);
    }
}
