<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('mobile')->unique();
            $table->string('address')->nullable();
            $table->string('area');
            $table->string('gst_number')->nullable();
            $table->decimal('credit_limit', 12, 2)->default(0);
            $table->string('default_price_level')->default('retail');
            $table->text('payment_terms')->nullable();
            $table->boolean('is_active')->default(true);
            $table->foreignId('sales_rep_id')->nullable()->constrained('users'); // The rep managing this customer
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
