<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->decimal('base_cost', 12, 2)->default(0)->after('name');
        });

        Schema::table('product_pack_sizes', function (Blueprint $table) {
            $table->decimal('height', 8, 2)->nullable()->comment('cm');
            $table->decimal('width', 8, 2)->nullable()->comment('cm');
            $table->decimal('length', 8, 2)->nullable()->comment('cm');
            $table->decimal('weight', 8, 2)->nullable()->comment('kg');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('product_pack_sizes', function (Blueprint $table) {
            $table->dropColumn(['height', 'width', 'length', 'weight']);
        });

        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn('base_cost');
        });
    }
};
