<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Update Users Table for Sales Rep details
        Schema::table('users', function (Blueprint $table) {
            $table->string('address')->nullable()->after('mobile');
            $table->decimal('commission_cash', 5, 2)->default(0)->after('is_active'); // e.g. 5.00%
            $table->decimal('commission_credit', 5, 2)->default(0)->after('commission_cash');
            $table->decimal('commission_cheque', 5, 2)->default(0)->after('commission_credit');
        });

        // 2. Vehicle Stocks (Inventory on the truck)
        Schema::create('vehicle_stocks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_id')->constrained()->onDelete('cascade');
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->decimal('quantity', 12, 2)->default(0); // Base units on truck
            $table->timestamps();
        });

        // 3. Stock Transfers (Logging movement from Warehouse to Truck)
        Schema::create('stock_transfers', function (Blueprint $table) {
            $table->id();
            $table->string('transfer_date');
            $table->foreignId('vehicle_id')->constrained();
            $table->foreignId('from_stock_location')->nullable(); // Null = Main Warehouse
            // If we had multiple warehouses, we'd ID them. For now, assuming Main -> Truck.
            
            $table->foreignId('product_id')->constrained();
            $table->foreignId('product_pack_size_id')->constrained('product_pack_sizes');
            $table->integer('pack_quantity'); // Pack count moved
            $table->decimal('converted_base_quantity', 12, 2); // Total units moved
            
            $table->foreignId('created_by')->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_transfers');
        Schema::dropIfExists('vehicle_stocks');
        
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['address', 'commission_cash', 'commission_credit', 'commission_cheque']);
        });
    }
};
