<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->string('bank_name')->nullable()->after('method');
            $table->string('cheque_number')->nullable()->after('bank_name');
            $table->date('cheque_date')->nullable()->after('cheque_number'); // Filled date
            $table->string('cheque_image_path')->nullable()->after('cheque_date');
            $table->string('cheque_status')->default('pending')->after('cheque_image_path'); // pending, cleared, returned
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            //
        });
    }
};
