<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('New Delivery & Truck Loading') }}
        </h2>
    </x-slot>

    <div class="py-12" x-data="deliveryForm()">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <form action="{{ route('admin.deliveries.store') }}" method="POST" class="space-y-6">
                @csrf
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <!-- Assignment Section -->
                    <div class="md:col-span-1 space-y-6">
                        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow border border-gray-200 dark:border-gray-700">
                            <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">Assignment</h3>
                            
                            <div class="space-y-4">
                                <div>
                                    <x-input-label for="vehicle_id" :value="__('Select Truck')" />
                                    <select id="vehicle_id" name="vehicle_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" required>
                                        <option value="">Choose a Truck</option>
                                        @foreach($vehicles as $vehicle)
                                            <option value="{{ $vehicle->id }}">{{ $vehicle->truck_number }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div>
                                    <x-input-label for="driver_id" :value="__('Assign Driver')" />
                                    <select id="driver_id" name="driver_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" required>
                                        <option value="">Choose a Driver</option>
                                        @foreach($drivers as $driver)
                                            <option value="{{ $driver->id }}">{{ $driver->name }}</option>
                                        @endforeach
                                    </select>
                                    <p class="mt-1 text-xs text-gray-400">Only available drivers are shown.</p>
                                </div>

                                <div>
                                    <x-input-label for="sales_rep_id" :value="__('Assign Sales Rep')" />
                                    <select id="sales_rep_id" name="sales_rep_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" required>
                                        <option value="">Choose a Rep</option>
                                        @foreach($salesReps as $rep)
                                            <option value="{{ $rep->id }}">{{ $rep->name }}</option>
                                        @endforeach
                                    </select>
                                    <p class="mt-1 text-xs text-gray-400">Only available reps are shown.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Products Loading Section -->
                    <div class="md:col-span-2">
                        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow border border-gray-200 dark:border-gray-700">
                            <div class="flex justify-between items-center mb-4">
                                <h3 class="text-lg font-medium text-gray-900 dark:text-white">Load Goods</h3>
                                <button type="button" @click="addItem()" class="inline-flex items-center px-3 py-1 bg-green-600 text-white rounded-md text-sm hover:bg-green-700">
                                    + Add Product
                                </button>
                            </div>

                            <div class="space-y-4">
                                <template x-for="(item, index) in items" :key="index">
                                    <div class="flex items-end gap-3 p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                                        <div class="flex-1">
                                            <x-input-label value="Product" />
                                            <select x-bind:name="`items[${index}][product_id]`" x-model="item.product_id" @change="updatePacks(index)" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" required>
                                                <option value="">Select Product</option>
                                                @foreach($products as $product)
                                                    <option value="{{ $product->id }}">{{ $product->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="w-1/4">
                                            <x-input-label value="Pack/Size" />
                                            <select x-bind:name="`items[${index}][product_pack_size_id]`" x-model="item.pack_id" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" required>
                                                <option value="">Select Pack</option>
                                                <template x-for="p in item.availablePacks" :key="p.id">
                                                    <option :value="p.id" x-text="p.size_name"></option>
                                                </template>
                                            </select>
                                        </div>

                                        <div class="w-1/4">
                                            <x-input-label value="Quantity" />
                                            <x-text-input type="number" x-bind:name="`items[${index}][quantity]`" x-model="item.quantity" min="1" class="mt-1 block w-full" required />
                                        </div>

                                        <button type="button" @click="removeItem(index)" class="p-2 text-red-500 hover:text-red-700 bg-white dark:bg-gray-800 rounded-md shadow-sm border border-gray-300 dark:border-gray-700">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                        </button>
                                    </div>
                                </template>
                            </div>

                            <div x-show="items.length === 0" class="mt-4 p-8 text-center border-2 border-dashed border-gray-300 dark:border-gray-700 rounded-lg text-gray-500">
                                Click "Add Product" to start loading the truck.
                            </div>

                            <div class="mt-8 flex justify-end">
                                <x-primary-button>
                                    {{ __('Create Delivery & Finalize Loading') }}
                                </x-primary-button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        function deliveryForm() {
            return {
                items: [],
                products: @json($products),
                addItem() {
                    this.items.push({
                        product_id: '',
                        pack_id: '',
                        quantity: 1,
                        availablePacks: []
                    });
                },
                removeItem(index) {
                    this.items.splice(index, 1);
                },
                updatePacks(index) {
                    const productId = this.items[index].product_id;
                    const product = this.products.find(p => p.id == productId);
                    this.items[index].availablePacks = product ? product.pack_sizes : [];
                    this.items[index].pack_id = '';
                }
            }
        }
    </script>
</x-app-layout>
