<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
                {{ __('Delivery Details') }} #{{ $delivery->id }}
            </h2>
            <span class="px-3 py-1 rounded-full text-sm font-semibold 
                @if($delivery->status === 'completed') bg-green-100 text-green-800 
                @elseif($delivery->status === 'ongoing') bg-yellow-100 text-yellow-800 
                @elseif($delivery->status === 'unloading') bg-purple-100 text-purple-800
                @else bg-blue-100 text-blue-800 @endif">
                {{ ucfirst($delivery->status) }}
            </span>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Trip Info -->
                <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow border border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">Trip Information</h3>
                    <div class="space-y-3 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-500">Truck:</span>
                            <span class="font-bold text-indigo-600 dark:text-indigo-400">{{ $delivery->vehicle->truck_number }}</span>
                        </div>
                        <div class="flex justify-between border-t dark:border-gray-700 pt-2">
                            <span class="text-gray-500">Driver:</span>
                            <span class="font-medium text-gray-900 dark:text-white">{{ $delivery->driver->name }}</span>
                        </div>
                        <div class="flex justify-between border-t dark:border-gray-700 pt-2">
                            <span class="text-gray-500">Sales Rep:</span>
                            <span class="font-medium text-gray-900 dark:text-white">{{ $delivery->salesRep->name }}</span>
                        </div>
                        <div class="flex justify-between border-t dark:border-gray-700 pt-2">
                            <span class="text-gray-500">Started:</span>
                            <span class="text-gray-900 dark:text-white">{{ $delivery->started_at ? $delivery->started_at->format('M d, Y H:i') : 'N/A' }}</span>
                        </div>
                        <div class="flex justify-between border-t dark:border-gray-700 pt-2">
                            <span class="text-gray-500">Ended:</span>
                            <span class="text-gray-900 dark:text-white">{{ $delivery->ended_at ? $delivery->ended_at->format('M d, Y H:i') : 'N/A' }}</span>
                        </div>
                    </div>
                </div>

                <!-- Summary Stats -->
                <div class="md:col-span-2 bg-white dark:bg-gray-800 p-6 rounded-lg shadow border border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">Goods Summary</h3>
                    <div class="overflow-x-auto">
                        <table class="w-full text-sm text-left">
                            <thead class="bg-gray-50 dark:bg-gray-700 text-gray-600 dark:text-gray-400 uppercase text-xs">
                                <tr>
                                    <th class="px-4 py-2">Product</th>
                                    <th class="px-4 py-2 text-center">Loaded</th>
                                    <th class="px-4 py-2 text-center">Unloaded (Sys)</th>
                                    <th class="px-4 py-2 text-center">Physical</th>
                                    <th class="px-4 py-2 text-center">Sold</th>
                                    <th class="px-4 py-2 text-center">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($delivery->items as $item)
                                    @php
                                        // Sold = Loaded - Unloaded (Sys)
                                        $sold = $item->loaded_quantity - ($item->unloaded_quantity ?? 0);
                                        $discrepancy = $item->unloaded_quantity !== null && $item->unloaded_quantity != $item->physical_unloaded_quantity;
                                    @endphp
                                    <tr class="border-b dark:border-gray-700">
                                        <td class="px-4 py-3 font-medium">{{ $item->product->name }}</td>
                                        <td class="px-4 py-3 text-center">{{ $item->loaded_quantity }}</td>
                                        <td class="px-4 py-3 text-center">{{ $item->unloaded_quantity ?? '---' }}</td>
                                        <td class="px-4 py-3 text-center {{ $discrepancy ? 'text-red-600 font-bold' : '' }}">
                                            {{ $item->physical_unloaded_quantity ?? '---' }}
                                        </td>
                                        <td class="px-4 py-3 text-center font-bold text-green-600">
                                            {{ $delivery->status === 'completed' || $delivery->status === 'unloading' ? $sold : '---' }}
                                        </td>
                                        <td class="px-4 py-3 text-center">
                                            @if($discrepancy)
                                                <span class="text-xs bg-red-100 text-red-800 px-2 py-0.5 rounded-full">Error</span>
                                            @elseif($item->unloaded_quantity !== null)
                                                <span class="text-xs bg-green-100 text-green-800 px-2 py-0.5 rounded-full">OK</span>
                                            @else
                                                <span class="text-xs bg-gray-100 text-gray-800 px-2 py-0.5 rounded-full">Pending</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="flex justify-between">
                <a href="{{ route('admin.deliveries.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
                    Back to List
                </a>

                @if($delivery->status === 'unloading')
                    <a href="{{ route('admin.deliveries.unload-form', $delivery) }}" class="inline-flex items-center px-6 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700">
                        Proceed to Unloading & Verification
                    </a>
                @endif
            </div>
        </div>
    </div>
</x-app-layout>
