<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
            <div>
                <h2 class="font-bold text-2xl text-gray-900 leading-tight">
                    💰 Payroll Management
                </h2>
                <p class="text-sm text-gray-600 mt-1">Manage employee salaries, EPF/ETF, and deductions</p>
            </div>
            <div class="flex flex-wrap gap-2">
                <a href="{{ route('admin.salary-advances.index') }}" 
                   class="inline-flex items-center px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white text-sm font-medium rounded-lg shadow-sm transition-all duration-200 hover:shadow-md">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Salary Advances
                </a>
                <a href="{{ route('admin.loans.index') }}" 
                   class="inline-flex items-center px-4 py-2 bg-indigo-600 hover:bg-indigo-700 text-white text-sm font-medium rounded-lg shadow-sm transition-all duration-200 hover:shadow-md">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                    Loans
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-6 sm:py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="mb-6 bg-gradient-to-r from-green-50 to-emerald-50 border-l-4 border-green-500 text-green-800 px-4 py-3 rounded-lg shadow-sm animate-fade-in">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('success') }}
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-6 bg-gradient-to-r from-red-50 to-rose-50 border-l-4 border-red-500 text-red-800 px-4 py-3 rounded-lg shadow-sm">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('error') }}
                    </div>
                </div>
            @endif

            <!-- Generate Payroll Card -->
            <div class="bg-gradient-to-br from-blue-600 to-indigo-700 rounded-2xl shadow-xl mb-6 overflow-hidden">
                <div class="p-6 sm:p-8">
                    <div class="flex items-center mb-4">
                        <div class="bg-white/20 backdrop-blur-sm p-3 rounded-xl mr-4">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <div class="flex-1">
                            <h3 class="text-xl sm:text-2xl font-bold text-white">Generate Monthly Payroll</h3>
                            <p class="text-blue-100 text-sm mt-1">Process salaries with automatic EPF/ETF calculations</p>
                        </div>
                    </div>
                    
                    <form method="POST" action="{{ route('admin.payroll.generate') }}" class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                        @csrf
                        <div>
                            <label class="block text-sm font-medium text-blue-100 mb-2">Month</label>
                            <input type="month" name="month" value="{{ $month }}" 
                                   class="w-full px-4 py-3 bg-white/10 backdrop-blur-sm border border-white/20 text-white placeholder-blue-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-white/50 transition-all">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-blue-100 mb-2">Payment Date</label>
                            <input type="date" name="payment_date" value="{{ now()->format('Y-m-d') }}" 
                                   class="w-full px-4 py-3 bg-white/10 backdrop-blur-sm border border-white/20 text-white placeholder-blue-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-white/50 transition-all" required>
                        </div>
                        <div class="flex items-end">
                            <button type="submit" 
                                    class="w-full px-6 py-3 bg-white text-blue-700 font-semibold rounded-xl hover:bg-blue-50 transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                                <span class="flex items-center justify-center">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                                    </svg>
                                    Generate Payroll
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Filter Card -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 mb-6">
                <div class="p-4 sm:p-6">
                    <form method="GET" class="flex flex-col sm:flex-row gap-4">
                        <div class="flex-1">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Filter by Month</label>
                            <input type="month" name="month" value="{{ $month }}" 
                                   class="w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                        </div>
                        <div class="flex items-end">
                            <button type="submit" 
                                    class="w-full sm:w-auto px-6 py-2.5 bg-gray-700 hover:bg-gray-800 text-white font-medium rounded-lg transition-all duration-200 shadow-sm hover:shadow-md">
                                Apply Filter
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Payroll Table -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                <div class="p-4 sm:p-6 border-b border-gray-200 bg-gradient-to-r from-gray-50 to-white">
                    <h3 class="text-lg font-bold text-gray-900">
                        📊 Payroll for {{ \Carbon\Carbon::parse($month)->format('F Y') }}
                    </h3>
                    <p class="text-sm text-gray-600 mt-1">Complete salary breakdown with EPF/ETF calculations</p>
                </div>
                
                <!-- Mobile Cards View -->
                <div class="block lg:hidden">
                    @forelse($payrollData as $data)
                        <div class="border-b border-gray-200 p-4 hover:bg-gray-50 transition-colors">
                            <div class="flex items-start justify-between mb-3">
                                <div class="flex-1">
                                    <h4 class="font-semibold text-gray-900">{{ $data['rep']->name }}</h4>
                                    <p class="text-xs text-gray-500">{{ $data['rep']->email }}</p>
                                    @if($data['rep']->epf_number)
                                        <p class="text-xs text-gray-400 mt-1">EPF: {{ $data['rep']->epf_number }}</p>
                                    @endif
                                </div>
                                @if($data['payroll'])
                                    <span class="px-2 py-1 text-xs rounded-full 
                                        {{ $data['payroll']->status === 'paid' ? 'bg-green-100 text-green-800' : 
                                           ($data['payroll']->status === 'processed' ? 'bg-blue-100 text-blue-800' : 'bg-yellow-100 text-yellow-800') }}">
                                        {{ ucfirst($data['payroll']->status) }}
                                    </span>
                                @endif
                            </div>

                            <div class="grid grid-cols-2 gap-3 mb-3">
                                <div class="bg-blue-50 rounded-lg p-3">
                                    <p class="text-xs text-blue-600 font-medium">Gross Salary</p>
                                    <p class="text-lg font-bold text-blue-900">Rs. {{ number_format($data['gross_salary'], 0) }}</p>
                                </div>
                                <div class="bg-green-50 rounded-lg p-3">
                                    <p class="text-xs text-green-600 font-medium">Net Salary</p>
                                    <p class="text-lg font-bold text-green-900">Rs. {{ number_format($data['net_salary'], 0) }}</p>
                                </div>
                            </div>

                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Basic Salary:</span>
                                    <span class="font-medium">Rs. {{ number_format($data['basic_salary'], 2) }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Commission:</span>
                                    <span class="font-medium">Rs. {{ number_format($data['total_commission'], 2) }}</span>
                                </div>
                                <div class="flex justify-between text-red-600">
                                    <span>EPF (8%):</span>
                                    <span class="font-medium">- Rs. {{ number_format($data['epf_employee'], 2) }}</span>
                                </div>
                                <div class="flex justify-between text-red-600">
                                    <span>ETF (3%):</span>
                                    <span class="font-medium">- Rs. {{ number_format($data['etf_employee'], 2) }}</span>
                                </div>
                                @if($data['salary_advance_deduction'] > 0)
                                <div class="flex justify-between text-orange-600">
                                    <span>Advances:</span>
                                    <span class="font-medium">- Rs. {{ number_format($data['salary_advance_deduction'], 2) }}</span>
                                </div>
                                @endif
                                @if($data['loan_deduction'] > 0)
                                <div class="flex justify-between text-orange-600">
                                    <span>Loans:</span>
                                    <span class="font-medium">- Rs. {{ number_format($data['loan_deduction'], 2) }}</span>
                                </div>
                                @endif
                            </div>

                            <div class="mt-3 pt-3 border-t border-gray-200 flex gap-2">
                                <button onclick="toggleEmployeeDetails({{ $data['rep']->id }})" 
                                        class="flex-1 text-xs px-3 py-2 bg-blue-50 text-blue-700 rounded-lg hover:bg-blue-100 transition-colors">
                                    {{ $data['rep']->epf_number ? 'Edit' : 'Add' }} Details
                                </button>
                                @if($data['payroll'])
                                    <a href="{{ route('admin.payroll.show', $data['payroll']->id) }}" 
                                       class="flex-1 text-xs px-3 py-2 bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 transition-colors text-center">
                                        View Full
                                    </a>
                                @endif
                            </div>

                            <div id="employee-details-{{ $data['rep']->id }}" class="hidden mt-3 p-3 bg-gray-50 rounded-lg">
                                <form method="POST" action="{{ route('admin.payroll.update-details', $data['rep']->id) }}">
                                    @csrf
                                    <div class="space-y-2">
                                        <input type="text" name="epf_number" placeholder="EPF Number" 
                                               value="{{ $data['rep']->epf_number }}"
                                               class="w-full text-sm px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                        <input type="text" name="etf_number" placeholder="ETF Number" 
                                               value="{{ $data['rep']->etf_number }}"
                                               class="w-full text-sm px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                        <input type="text" name="bank_name" placeholder="Bank Name" 
                                               value="{{ $data['rep']->bank_name }}"
                                               class="w-full text-sm px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                        <input type="text" name="bank_account_number" placeholder="Account Number" 
                                               value="{{ $data['rep']->bank_account_number }}"
                                               class="w-full text-sm px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                        <input type="text" name="bank_branch" placeholder="Branch" 
                                               value="{{ $data['rep']->bank_branch }}"
                                               class="w-full text-sm px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                        <button type="submit" class="w-full bg-blue-600 text-white px-3 py-2 rounded-lg text-sm font-medium hover:bg-blue-700 transition-colors">
                                            Save Details
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    @empty
                        <div class="p-12 text-center">
                            <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path>
                            </svg>
                            <p class="text-gray-500">No sales representatives found</p>
                        </div>
                    @endforelse
                </div>

                <!-- Desktop Table View -->
                <div class="hidden lg:block overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Employee</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">EPF/ETF</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Basic</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Commission</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Gross</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">EPF (8%)</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">ETF (3%)</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Deductions</th>
                                <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Net Salary</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                                <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($payrollData as $data)
                                <tr class="hover:bg-blue-50/30 transition-colors">
                                    <td class="px-4 py-4">
                                        <div class="font-medium text-gray-900">{{ $data['rep']->name }}</div>
                                        <div class="text-sm text-gray-500">{{ $data['rep']->email }}</div>
                                        @if($data['rep']->epf_number || $data['rep']->etf_number)
                                            <div class="text-xs text-gray-400 mt-1">
                                                @if($data['rep']->epf_number)EPF: {{ $data['rep']->epf_number }}@endif
                                                @if($data['rep']->etf_number) | ETF: {{ $data['rep']->etf_number }}@endif
                                            </div>
                                        @endif
                                    </td>
                                    <td class="px-4 py-4">
                                        <button onclick="toggleEmployeeDetails({{ $data['rep']->id }})" 
                                                class="text-blue-600 hover:text-blue-800 text-sm font-medium hover:underline">
                                            {{ $data['rep']->epf_number ? '✏️ Edit' : '➕ Add' }}
                                        </button>
                                        <div id="employee-details-{{ $data['rep']->id }}" class="hidden mt-2 p-3 bg-gray-50 rounded-lg shadow-sm">
                                            <form method="POST" action="{{ route('admin.payroll.update-details', $data['rep']->id) }}">
                                                @csrf
                                                <div class="space-y-2">
                                                    <input type="text" name="epf_number" placeholder="EPF Number" 
                                                           value="{{ $data['rep']->epf_number }}"
                                                           class="w-full text-sm px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                                    <input type="text" name="etf_number" placeholder="ETF Number" 
                                                           value="{{ $data['rep']->etf_number }}"
                                                           class="w-full text-sm px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                                    <input type="text" name="bank_name" placeholder="Bank Name" 
                                                           value="{{ $data['rep']->bank_name }}"
                                                           class="w-full text-sm px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                                    <input type="text" name="bank_account_number" placeholder="Account Number" 
                                                           value="{{ $data['rep']->bank_account_number }}"
                                                           class="w-full text-sm px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                                    <input type="text" name="bank_branch" placeholder="Branch" 
                                                           value="{{ $data['rep']->bank_branch }}"
                                                           class="w-full text-sm px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                                                    <button type="submit" class="w-full bg-blue-600 text-white px-3 py-2 rounded-lg text-sm font-medium hover:bg-blue-700 transition-colors">
                                                        💾 Save Details
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </td>
                                    <td class="px-4 py-4 text-right font-medium">Rs. {{ number_format($data['basic_salary'], 0) }}</td>
                                    <td class="px-4 py-4 text-right font-medium">Rs. {{ number_format($data['total_commission'], 0) }}</td>
                                    <td class="px-4 py-4 text-right font-bold text-blue-600">Rs. {{ number_format($data['gross_salary'], 0) }}</td>
                                    <td class="px-4 py-4 text-right text-red-600 font-medium">Rs. {{ number_format($data['epf_employee'], 0) }}</td>
                                    <td class="px-4 py-4 text-right text-red-600 font-medium">Rs. {{ number_format($data['etf_employee'], 0) }}</td>
                                    <td class="px-4 py-4 text-right font-semibold text-red-600">Rs. {{ number_format($data['total_deductions'], 0) }}</td>
                                    <td class="px-4 py-4 text-right font-bold text-green-600 text-lg">Rs. {{ number_format($data['net_salary'], 0) }}</td>
                                    <td class="px-4 py-4">
                                        @if($data['payroll'])
                                            <span class="px-3 py-1 text-xs font-medium rounded-full 
                                                {{ $data['payroll']->status === 'paid' ? 'bg-green-100 text-green-800' : 
                                                   ($data['payroll']->status === 'processed' ? 'bg-blue-100 text-blue-800' : 'bg-yellow-100 text-yellow-800') }}">
                                                {{ ucfirst($data['payroll']->status) }}
                                            </span>
                                        @else
                                            <span class="px-3 py-1 text-xs font-medium rounded-full bg-gray-100 text-gray-600">Not Generated</span>
                                        @endif
                                    </td>
                                    <td class="px-4 py-4">
                                        @if($data['payroll'])
                                            <div class="flex flex-col gap-1">
                                                <a href="{{ route('admin.payroll.show', $data['payroll']->id) }}" 
                                                   class="text-blue-600 hover:text-blue-800 text-sm font-medium hover:underline">👁️ View</a>
                                                @if($data['payroll']->status !== 'paid')
                                                    <form method="POST" action="{{ route('admin.payroll.mark-paid', $data['payroll']->id) }}">
                                                        @csrf
                                                        <button type="submit" class="text-green-600 hover:text-green-800 text-sm font-medium hover:underline">
                                                            ✓ Mark Paid
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        @else
                                            <span class="text-gray-400 text-sm">-</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr class="bg-gradient-to-r from-gray-50 to-blue-50/30">
                                    <td colspan="11" class="px-4 py-2 text-xs text-gray-600">
                                        <div class="flex flex-wrap justify-between gap-2">
                                            <div>
                                                <strong class="text-gray-700">Employer Contributions:</strong> 
                                                EPF (12%): <span class="font-semibold">Rs. {{ number_format($data['epf_employer'], 0) }}</span> | 
                                                ETF (3%): <span class="font-semibold">Rs. {{ number_format($data['etf_employer'], 0) }}</span> | 
                                                <strong class="text-blue-700">Total: Rs. {{ number_format($data['epf_employer'] + $data['etf_employer'], 0) }}</strong>
                                            </div>
                                            @if($data['rep']->bank_name)
                                                <div class="text-gray-600">
                                                    🏦 <strong>Bank:</strong> {{ $data['rep']->bank_name }} | 
                                                    <strong>A/C:</strong> {{ $data['rep']->bank_account_number }}
                                                </div>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="11" class="px-4 py-12 text-center">
                                        <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path>
                                        </svg>
                                        <p class="text-gray-500 text-lg">No sales representatives found</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                        @if($payrollData->isNotEmpty())
                            <tfoot class="bg-gradient-to-r from-gray-100 to-blue-100 font-bold">
                                <tr>
                                    <td colspan="2" class="px-4 py-4 text-right text-gray-700">TOTAL:</td>
                                    <td class="px-4 py-4 text-right">Rs. {{ number_format($payrollData->sum('basic_salary'), 0) }}</td>
                                    <td class="px-4 py-4 text-right">Rs. {{ number_format($payrollData->sum('total_commission'), 0) }}</td>
                                    <td class="px-4 py-4 text-right text-blue-700">Rs. {{ number_format($payrollData->sum('gross_salary'), 0) }}</td>
                                    <td class="px-4 py-4 text-right text-red-600">Rs. {{ number_format($payrollData->sum('epf_employee'), 0) }}</td>
                                    <td class="px-4 py-4 text-right text-red-600">Rs. {{ number_format($payrollData->sum('etf_employee'), 0) }}</td>
                                    <td class="px-4 py-4 text-right text-red-600">Rs. {{ number_format($payrollData->sum('total_deductions'), 0) }}</td>
                                    <td class="px-4 py-4 text-right text-green-700 text-lg">Rs. {{ number_format($payrollData->sum('net_salary'), 0) }}</td>
                                    <td colspan="2"></td>
                                </tr>
                                <tr class="bg-blue-600 text-white">
                                    <td colspan="2" class="px-4 py-3 text-right">EMPLOYER CONTRIBUTIONS:</td>
                                    <td colspan="3" class="px-4 py-3 text-left">
                                        EPF (12%): Rs. {{ number_format($payrollData->sum('epf_employer'), 0) }} | 
                                        ETF (3%): Rs. {{ number_format($payrollData->sum('etf_employer'), 0) }}
                                    </td>
                                    <td colspan="6" class="px-4 py-3 text-right text-lg">
                                        <strong>Total: Rs. {{ number_format($payrollData->sum('epf_employer') + $payrollData->sum('etf_employer'), 0) }}</strong>
                                    </td>
                                </tr>
                            </tfoot>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script>
        function toggleEmployeeDetails(userId) {
            const element = document.getElementById(`employee-details-${userId}`);
            element.classList.toggle('hidden');
        }
    </script>

    <style>
        @keyframes fade-in {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fade-in 0.3s ease-out;
        }
    </style>
</x-app-layout>
