<x-app-layout>
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <h1 class="text-2xl font-bold mb-6 text-gray-800">Cash Collections (To be Handed Over)</h1>
            
            @if($collections->isEmpty())
                <div class="p-6 bg-white border-b border-gray-200 rounded-lg shadow-sm text-center text-gray-500">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">All Clear!</h3>
                    <p class="mt-1 text-sm text-gray-500">No pending cash collections to receive.</p>
                </div>
            @else
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($collections as $col)
                    <div class="bg-white overflow-hidden shadow rounded-lg border border-gray-200">
                        <div class="p-5">
                            <div class="flex items-center">
                                <div class="flex-shrink-0">
                                    <svg class="h-6 w-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                    </svg>
                                </div>
                                <div class="ml-5 w-0 flex-1">
                                    <dl>
                                        <dt class="text-sm font-medium text-gray-500 truncate">
                                            {{ $col->collector->name ?? 'Unknown Rep' }}
                                        </dt>
                                        <dd>
                                            <div class="text-xs text-gray-500">{{ $col->collector->email }}</div>
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>
                        <div class="bg-gray-50 px-5 py-3">
                            <div class="flex justify-between items-center mb-2">
                                <div class="text-sm font-medium text-gray-500">Total Collected:</div>
                                <div class="text-sm font-bold text-gray-900">LKR {{ number_format($col->total_amount, 2) }}</div>
                            </div>
                            
                            @if($col->expenses > 0)
                            <div class="flex justify-between items-center mb-2 text-red-600">
                                <div class="text-sm font-medium">Less: Approved Expenses:</div>
                                <div class="text-sm font-bold">- LKR {{ number_format($col->expenses, 2) }}</div>
                            </div>
                            @endif

                            <div class="flex justify-between items-center border-t border-gray-200 pt-2 mb-4">
                                <div class="text-lg font-bold text-gray-900">Net Handover:</div>
                                <div class="text-lg font-bold text-green-700">LKR {{ number_format($col->net_handover, 2) }}</div>
                            </div>

                            <div class="mt-4">
                                <form action="{{ route('admin.reports.cash-collections.remit') }}" method="POST" onsubmit="return confirm('Confirm net handover of LKR {{ number_format($col->net_handover, 2) }} from {{ $col->collector->name }}? This will mark payments as remitted and expenses as reimbursed.')">
                                    @csrf
                                    <input type="hidden" name="sales_rep_id" value="{{ $col->collector->id }}">
                                    <input type="hidden" name="amount" value="{{ $col->net_handover }}">
                                    <button type="submit" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                        Confirm Receipt (Net: {{ number_format($col->net_handover, 2) }})
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
