<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Cheque Management') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    
                    @if(session('success'))
                        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Details</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Image</th>
                                    <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($cheques as $cheque)
                                    <tr class="@if($cheque->cheque_status == 'returned') bg-red-50 @elseif($cheque->cheque_status == 'cleared') bg-green-50 @endif">
                                        <td class="px-3 py-4 text-xs whitespace-nowrap">
                                            <div class="font-bold">{{ $cheque->created_at->format('Y-m-d') }}</div>
                                            <div class="text-gray-500">Filled: {{ $cheque->cheque_date ? \Carbon\Carbon::parse($cheque->cheque_date)->format('Y-m-d') : '-' }}</div>
                                        </td>
                                        <td class="px-3 py-4 text-xs">
                                            <div class="font-bold">{{ $cheque->customer->name }}</div>
                                            <div class="text-gray-500">{{ $cheque->customer->area }}</div>
                                            <div class="text-xs text-blue-500">Rep: {{ $cheque->collector->name ?? 'N/A' }}</div>
                                        </td>
                                        <td class="px-3 py-4 text-xs">
                                            <div>Bank: {{ $cheque->bank_name ?? 'N/A' }}</div>
                                            <div>No: {{ $cheque->cheque_number ?? 'N/A' }}</div>
                                        </td>
                                        <td class="px-3 py-4 text-xs font-bold text-gray-900">
                                            LKR {{ number_format($cheque->amount, 2) }}
                                        </td>
                                        <td class="px-3 py-4 text-xs">
                                            @if($cheque->cheque_image_path)
                                                <a href="{{ asset('storage/'.$cheque->cheque_image_path) }}" target="_blank" class="text-blue-600 hover:underline">View</a>
                                            @else
                                                <span class="text-gray-400">None</span>
                                            @endif
                                        </td>
                                        <td class="px-3 py-4 text-xs">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                @if($cheque->cheque_status == 'cleared') bg-green-100 text-green-800 
                                                @elseif($cheque->cheque_status == 'returned') bg-red-100 text-red-800 
                                                @else bg-yellow-100 text-yellow-800 @endif">
                                                {{ ucfirst($cheque->cheque_status) }}
                                            </span>
                                            
                                            <!-- Notification Logic for 2 days due -->
                                            @php
                                                $filledDate = \Carbon\Carbon::parse($cheque->cheque_date);
                                                $isOverdue = $filledDate->addDays(2)->isPast() && $cheque->cheque_status == 'pending';
                                            @endphp
                                            @if($isOverdue)
                                                <div class="text-red-600 font-bold mt-1 text-[10px] animate-pulse">Action Required</div>
                                            @endif
                                        </td>
                                        <td class="px-3 py-4 text-xs text-right whitespace-nowrap">
                                            @if($cheque->cheque_status == 'pending')
                                                <div class="flex flex-col space-y-1 items-end">
                                                    <form action="{{ route('admin.reports.cheques.update-status', $cheque->id) }}" method="POST">
                                                        @csrf
                                                        <input type="hidden" name="status" value="cleared">
                                                        <button type="submit" class="text-green-600 hover:text-green-900 font-bold">Mark Cleared</button>
                                                    </form>
                                                    <form action="{{ route('admin.reports.cheques.update-status', $cheque->id) }}" method="POST">
                                                        @csrf
                                                        <input type="hidden" name="status" value="returned">
                                                        <button type="submit" class="text-red-600 hover:text-red-900 font-bold">Mark Returned</button>
                                                    </form>
                                                </div>
                                            @else
                                                <span class="text-gray-400">Locked</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="px-6 py-4 text-center text-gray-500">No cheques found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        <div class="mt-4">
                            {{ $cheques->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
