@props(['active', 'href'])

@php
$classes = ($active ?? false)
            ? 'flex items-center w-full p-2 pl-4 transition-colors duration-200 text-blue-400 bg-gray-800 border-l-4 border-blue-500 rounded-r-md'
            : 'flex items-center w-full p-2 pl-4 transition-colors duration-200 text-gray-400 hover:text-white hover:bg-gray-800 border-l-4 border-transparent rounded-r-md';
@endphp

<a href="{{ $href }}" {{ $attributes->merge(['class' => $classes]) }}>
    <span class="w-2 h-2 mr-3 bg-current rounded-full opacity-50"></span>
    <span class="text-sm font-medium">{{ $slot }}</span>
</a>
