<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('New Customer') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('sales.customers.store') }}" method="POST">
                        @csrf
                        <div class="grid grid-cols-2 gap-6">
                            <div>
                                <x-input-label for="name" :value="__('Customer Name (Shop Name)')" />
                                <x-text-input id="name" class="block mt-1 w-full" type="text" name="name" :value="old('name')" required />
                                <x-input-error :messages="$errors->get('name')" class="mt-2" />
                            </div>
                             <div>
                                <x-input-label for="mobile" :value="__('Mobile Number')" />
                                <x-text-input id="mobile" class="block mt-1 w-full" type="text" name="mobile" :value="old('mobile')" required />
                                <x-input-error :messages="$errors->get('mobile')" class="mt-2" />
                            </div>
                             <div>
                                <x-input-label for="area" :value="__('Area / Town')" />
                                <x-text-input id="area" class="block mt-1 w-full" type="text" name="area" :value="old('area')" required />
                                <x-input-error :messages="$errors->get('area')" class="mt-2" />
                            </div>
                             <div>
                                <x-input-label for="address" :value="__('Full Address')" />
                                <x-text-input id="address" class="block mt-1 w-full" type="text" name="address" :value="old('address')" />
                                <x-input-error :messages="$errors->get('address')" class="mt-2" />
                            </div>
                             <div>
                                <x-input-label for="default_price_level" :value="__('Price Level')" />
                                <select name="default_price_level" class="block mt-1 w-full border-gray-300 rounded shadow-sm">
                                    <option value="Retail">Retail</option>
                                    <option value="Wholesale">Wholesale</option>
                                    <option value="VIP">VIP</option>
                                    <option value="VVIP">VVIP</option>
                                </select>
                                <x-input-error :messages="$errors->get('default_price_level')" class="mt-2" />
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button class="ml-4">
                                {{ __('Save Customer') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
