<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Collect Payment') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('sales.payments.store') }}" method="POST" enctype="multipart/form-data" x-data="{ method: 'Cash' }">
                        @csrf
                        
                        <!-- Customer Selection -->
                        <div class="mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Customer</label>
                            @if($selectedCustomer)
                                <input type="hidden" name="customer_id" value="{{ $selectedCustomer->id }}">
                                <div class="p-4 bg-gray-50 border rounded shadow-sm">
                                    <div class="text-lg font-bold">{{ $selectedCustomer->name }}</div>
                                    <div class="text-sm text-gray-600">{{ $selectedCustomer->address }}</div>
                                    <div class="mt-2 text-xl font-bold text-red-600">
                                        Total Due: LKR {{ number_format($selectedCustomer->outstanding, 2) }}
                                    </div>
                                    
                                    <!-- List of Invoices -->
                                    <div class="mt-4">
                                        <h4 class="text-xs font-bold uppercase text-gray-500 mb-2">Unpaid Invoices (FIFO)</h4>
                                        <ul class="text-sm border-t">
                                            @foreach($selectedCustomer->sales->where('balance_due', '>', 0.01) as $sale)
                                                <li class="flex justify-between py-2 border-b">
                                                    <span>{{ $sale->invoice_number }} ({{ $sale->created_at->format('Y-m-d') }})</span>
                                                    <span class="font-bold">LKR {{ number_format($sale->balance_due, 2) }}</span>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @else
                                <select name="customer_id" class="w-full border-gray-300 rounded shadow-sm" onchange="window.location.href='{{ route('sales.payments.create') }}?customer_id='+this.value">
                                    <option value="">-- Select Customer --</option>
                                    @foreach($customers as $c)
                                        <option value="{{ $c->id }}">{{ $c->name }}</option>
                                    @endforeach
                                </select>
                            @endif
                        </div>

                        <!-- Payment Details -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2">Amount (LKR)</label>
                                <input type="number" step="0.01" name="amount" class="w-full border-gray-300 rounded shadow-sm" required placeholder="0.00" value="{{ old('amount') }}">
                            </div>
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2">Method</label>
                                <select name="method" x-model="method" class="w-full border-gray-300 rounded shadow-sm">
                                    <option value="Cash">Cash</option>
                                    <option value="Cheque">Cheque</option>
                                </select>
                            </div>
                        </div>

                        <!-- Cheque Details -->
                        <div class="mt-4 p-4 bg-gray-50 border border-gray-200 rounded" x-show="method === 'Cheque'" style="display: none;">
                            <h4 class="font-bold text-sm text-gray-700 mb-3 border-b pb-1">Cheque Details</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-xs font-bold text-gray-600">Bank Name</label>
                                    <input type="text" name="bank_name" class="w-full border-gray-300 rounded text-sm" placeholder="e.g. BOC">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-600">Cheque Number</label>
                                    <input type="text" name="cheque_number" class="w-full border-gray-300 rounded text-sm" placeholder="XXXXXX">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-600">Cheque Date (Filled Date)</label>
                                    <input type="date" name="cheque_date" class="w-full border-gray-300 rounded text-sm">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-gray-600">Cheque Image</label>
                                    <input type="file" name="cheque_image" accept="image/*" class="w-full border bg-white rounded text-sm p-1">
                                </div>
                            </div>
                        </div>

                        <div class="mt-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Reference / Note</label>
                            <input type="text" name="reference" class="w-full border-gray-300 rounded shadow-sm" placeholder="Remarks">
                        </div>

                        <div class="mt-6 flex justify-end">
                            <a href="{{ route('sales.payments.index') }}" class="text-gray-600 mr-4 self-center text-sm">Cancel</a>
                            <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded shadow hover:bg-blue-700 font-bold">
                                Save Payment
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
