<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('My Profile & Bank Details') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
                    {{ session('success') }}
                </div>
            @endif

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4">Personal Information</h3>
                    
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Name</label>
                            <div class="text-gray-900">{{ $user->name }}</div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                            <div class="text-gray-900">{{ $user->email }}</div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Mobile</label>
                            <div class="text-gray-900">{{ $user->mobile ?? 'Not Set' }}</div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Basic Salary</label>
                            <div class="text-gray-900">Rs. {{ number_format($user->basic_salary ?? 0, 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4">EPF/ETF Information</h3>
                    
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">EPF Number</label>
                            <div class="text-gray-900">{{ $user->epf_number ?? 'Not Set' }}</div>
                            <p class="text-xs text-gray-500 mt-1">Contact admin to update</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">ETF Number</label>
                            <div class="text-gray-900">{{ $user->etf_number ?? 'Not Set' }}</div>
                            <p class="text-xs text-gray-500 mt-1">Contact admin to update</p>
                        </div>
                    </div>

                    <div class="mt-4 p-4 bg-blue-50 rounded">
                        <h4 class="font-semibold text-blue-900 mb-2">About EPF/ETF</h4>
                        <ul class="text-sm text-blue-800 space-y-1">
                            <li>• <strong>EPF (Employee Provident Fund):</strong> You contribute 8% and your employer contributes 12% of your gross salary</li>
                            <li>• <strong>ETF (Employee Trust Fund):</strong> Both you and your employer contribute 3% of your gross salary</li>
                            <li>• These contributions are automatically deducted from your salary each month</li>
                            <li>• Your EPF and ETF accumulate over time and are available upon retirement or resignation</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4">Update Bank Details</h3>
                    
                    <form method="POST" action="{{ route('sales.my-profile.update') }}">
                        @csrf
                        
                        <div class="space-y-4">
                            <div>
                                <label for="bank_name" class="block text-sm font-medium text-gray-700 mb-1">
                                    Bank Name <span class="text-red-500">*</span>
                                </label>
                                <input type="text" 
                                       id="bank_name" 
                                       name="bank_name" 
                                       value="{{ old('bank_name', $user->bank_name) }}"
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                       placeholder="e.g., Bank of Ceylon">
                                @error('bank_name')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="bank_account_number" class="block text-sm font-medium text-gray-700 mb-1">
                                    Account Number <span class="text-red-500">*</span>
                                </label>
                                <input type="text" 
                                       id="bank_account_number" 
                                       name="bank_account_number" 
                                       value="{{ old('bank_account_number', $user->bank_account_number) }}"
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                       placeholder="e.g., 1234567890">
                                @error('bank_account_number')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="bank_branch" class="block text-sm font-medium text-gray-700 mb-1">
                                    Branch <span class="text-red-500">*</span>
                                </label>
                                <input type="text" 
                                       id="bank_branch" 
                                       name="bank_branch" 
                                       value="{{ old('bank_branch', $user->bank_branch) }}"
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                       placeholder="e.g., Colombo Main Branch">
                                @error('bank_branch')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="p-4 bg-yellow-50 rounded">
                                <p class="text-sm text-yellow-800">
                                    <strong>Important:</strong> Please ensure your bank details are correct. Your salary will be transferred to this account.
                                </p>
                            </div>

                            <div class="flex gap-3">
                                <button type="submit" 
                                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-md">
                                    Update Bank Details
                                </button>
                                <a href="{{ route('sales.my-salary.index') }}" 
                                   class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-2 rounded-md">
                                    Back to Salary
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
