<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Bill New Order')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="<?php echo e(route('sales.billing.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        
                        <?php if($errors->any()): ?>
                            <div class="mb-4 p-4 bg-red-50 text-red-700 rounded border border-red-200">
                                <ul class="list-disc pl-5">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        
                        <div class="mb-4 p-4 bg-blue-50 rounded">
                            <span class="font-bold">Assigned Truck:</span> <?php echo e($user->vehicle ? $user->vehicle->truck_number : 'None'); ?>

                            <?php if(!$user->vehicle): ?>
                                <span class="text-red-500 font-bold block mt-1">Error: You must be assigned a truck to sell!</span>
                            <?php endif; ?>
                        </div>

                         <?php if($user->vehicle): ?>
                            <!-- Customer Selection -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Select Customer</label>
                                    <select name="customer_id" id="customer_select" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" required onchange="updateCustomerStats(this)">
                                        <option value="">Choose Customer...</option>
                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($customer->id); ?>" data-due="<?php echo e($customer->total_due); ?>">
                                                <?php echo e($customer->name); ?> (<?php echo e($customer->area); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <a href="<?php echo e(route('sales.customers.create')); ?>" class="text-xs text-blue-600 hover:underline mt-1 inline-block">+ New Customer</a>
                                </div>
                                <div id="customer-stats" class="bg-gray-50 border p-4 rounded-md hidden">
                                    <div class="flex justify-between text-sm">
                                        <span class="text-gray-600">Previous Total Due:</span>
                                        <span class="font-bold text-red-600" id="stat-prev-due">0.00</span>
                                    </div>
                                    <div class="flex justify-between text-sm mt-1">
                                        <span class="text-gray-600">Current Bill:</span>
                                        <span class="font-bold text-indigo-600" id="stat-current-bill">0.00</span>
                                    </div>
                                    <div class="flex justify-between text-base font-bold border-t mt-2 pt-2">
                                        <span>Estimated New Total:</span>
                                        <span class="text-gray-900" id="stat-estimated-total">0.00</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Product Grid -->
                            <h3 class="text-lg font-bold mb-2">Items</h3>
                            <div id="items-container">
                                 <div class="grid grid-cols-5 gap-4 mb-2 item-row">
                                    <div class="col-span-1">
                                        <label class="block text-sm font-medium text-gray-700">Product</label>
                                        <select name="items[0][product_id]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm product-select" onchange="updatePackSizes(this)">
                                            <option value="">Select...</option>
                                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($product->id); ?>" data-packs="<?php echo e(json_encode($product->packSizes)); ?>" data-stock="<?php echo e($product->current_stock); ?>"><?php echo e($product->name); ?> (Available: <?php echo e($product->current_stock); ?> units)</option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-span-1">
                                        <label class="block text-sm font-medium text-gray-700">Pack</label>
                                        <select name="items[0][product_pack_size_id]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm pack-select" onchange="updatePrices(this)">
                                            <option value="">Select...</option>
                                        </select>
                                    </div>
                                    <div class="col-span-1">
                                        <label class="block text-sm font-medium text-gray-700">Price Level</label>
                                        <select name="items[0][price_level]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm price-level-select" onchange="setPrice(this)">
                                            <option value="">Select...</option>
                                        </select>
                                    </div>
                                    <div class="col-span-1">
                                        <label class="block text-sm font-medium text-gray-700">Qty</label>
                                        <input type="number" name="items[0][quantity]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm qty-input" oninput="validateQty(this); calculateTotal()" onchange="calculateTotal()" placeholder="1">
                                    </div>
                                    <div class="col-span-1">
                                        <label class="block text-sm font-medium text-gray-700">Unit Price</label>
                                        <input type="number" step="0.01" name="items[0][unit_price]" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm price-input" onchange="calculateTotal()" placeholder="0.00">
                                    </div>
                                </div>
                            </div>
                            <button type="button" onclick="addItemRow()" class="mt-2 text-sm text-blue-600 hover:text-blue-900">+ Add Another Item</button>

                            <!-- Total & Payment -->
                            <!-- Payment Section -->
                            <div class="mt-6 border-t pt-4">
                                <div class="flex justify-between text-lg font-bold">
                                    <span>Total Amount:</span>
                                    <span id="display-total">0.00</span>
                                </div>
                            </div>

                            <div class="mt-4 bg-gray-50 p-4 rounded border border-gray-200">
                                <h4 class="font-bold text-gray-700 mb-3">Invoice Summary (Credit Sale)</h4>
                                
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                     <div class="p-3 rounded border border-gray-200 bg-white">
                                        <label class="block text-xs font-bold text-gray-500 uppercase">Previous Due</label>
                                        <div class="text-lg font-bold text-gray-700 mt-1" id="summary-prev-due">0.00</div>
                                    </div>

                                    <div class="p-3 rounded border border-indigo-200 bg-indigo-50">
                                        <label class="block text-xs font-bold text-indigo-500 uppercase">Current Bill</label>
                                        <div class="text-lg font-bold text-indigo-700 mt-1" id="summary-current-bill">0.00</div>
                                    </div>

                                    <div class="p-3 rounded border border-red-200 bg-red-50">
                                        <label class="block text-xs font-bold text-red-600 uppercase">New Total Outstanding</label>
                                        <div class="text-xl font-bold text-red-600 mt-1" id="summary-new-total">0.00</div>
                                    </div>
                                </div>
                            </div>

                            <div class="flex items-center justify-end mt-4">
                                <?php if (isset($component)) { $__componentOriginald411d1792bd6cc877d687758b753742c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald411d1792bd6cc877d687758b753742c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.primary-button','data' => ['class' => 'ml-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'ml-4']); ?>
                                    <?php echo e(__('Create Bill & Print PDF')); ?>

                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald411d1792bd6cc877d687758b753742c)): ?>
<?php $attributes = $__attributesOriginald411d1792bd6cc877d687758b753742c; ?>
<?php unset($__attributesOriginald411d1792bd6cc877d687758b753742c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald411d1792bd6cc877d687758b753742c)): ?>
<?php $component = $__componentOriginald411d1792bd6cc877d687758b753742c; ?>
<?php unset($__componentOriginald411d1792bd6cc877d687758b753742c); ?>
<?php endif; ?>
                            </div>
                        <?php else: ?>
                             <div class="text-center py-4">Cannot proceed without assigned vehicle.</div>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
     <script>
        let itemCount = 1;

        function updatePackSizes(selectElement) {
            const row = selectElement.closest('.item-row');
            const packSelect = row.querySelector('.pack-select');
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            
            let packs = [];
            try {
                packs = JSON.parse(selectedOption.getAttribute('data-packs') || '[]');
            } catch (e) { console.error('Error parsing packs', e); }

            // Reset Pack Select
            packSelect.innerHTML = '<option value="">Select Pack...</option>';
            packs.forEach(pack => {
                const option = document.createElement('option');
                option.value = pack.id;
                option.text = pack.size_name + ' (x' + pack.quantity + ')';
                option.setAttribute('data-prices', JSON.stringify(pack.price_levels || []));
                
                // NEW: Store pack quantity for validation
                option.setAttribute('data-pack-qty', pack.quantity);
                
                packSelect.appendChild(option);
            });
            
            // Clear Price Levels & Quantity
            row.querySelector('.price-level-select').innerHTML = '<option value="">Select...</option>';
            row.querySelector('.qty-input').value = '';
            row.querySelector('.qty-input').removeAttribute('max');
        }

        function updatePrices(selectElement) {
             const row = selectElement.closest('.item-row');
             const priceLevelSelect = row.querySelector('.price-level-select');
             const selectedOption = selectElement.options[selectElement.selectedIndex];
             
             let prices = [];
             try {
                prices = JSON.parse(selectedOption.getAttribute('data-prices') || '[]');
             } catch (e) { console.error('Error parsing prices', e); }
             
             priceLevelSelect.innerHTML = '<option value="">Select Level...</option>';
             if (prices.length > 0) {
                 prices.forEach(pl => {
                     const option = document.createElement('option');
                     option.value = pl.price_level;
                     option.text = pl.price_level + ' (' + pl.price + ')';
                     option.setAttribute('data-price', pl.price);
                     priceLevelSelect.appendChild(option);
                 });
             } else {
                 const option = document.createElement('option');
                 option.text = "No prices set";
                 priceLevelSelect.appendChild(option);
             }
             
             // NEW: Trigger validation update
             validateQty(row.querySelector('.qty-input'));
        }
        
        function setPrice(selectElement) {
            const row = selectElement.closest('.item-row');
            const priceInput = row.querySelector('.price-input');
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            const price = selectedOption.getAttribute('data-price');
            
            if (price) {
                priceInput.value = price;
                calculateTotal();
            }
        }

        // NEW: Validate Quantity against Stock
        function validateQty(input) {
            const row = input.closest('.item-row');
            const productSelect = row.querySelector('.product-select');
            const packSelect = row.querySelector('.pack-select');
            
            const productOption = productSelect.options[productSelect.selectedIndex];
            const packOption = packSelect.options[packSelect.selectedIndex];
            
            if (!productOption || !packOption) return;
            
            const currentStock = parseFloat(productOption.getAttribute('data-stock')) || 0;
            const packQty = parseFloat(packOption.getAttribute('data-pack-qty')) || 1;
            
            const maxAllowed = Math.floor(currentStock / packQty);
            
            // Set Max attribute
            input.setAttribute('max', maxAllowed);
            input.setAttribute('title', 'Max available: ' + maxAllowed);
            
            // Check value
            let qty = parseFloat(input.value);
            if (qty > maxAllowed) {
                alert('Insufficient Stock! You only have ' + currentStock + ' units (' + maxAllowed + ' packs) available.');
                input.value = maxAllowed;
            }
            if (qty < 1 && input.value !== '') {
                input.value = 1;
            }
        }
        
        function updateCustomerStats(select) {
            const stats = document.getElementById('customer-stats');
            const prevDueDisplay = document.getElementById('summary-prev-due');
            
            if (select.value) {
                const due = parseFloat(select.options[select.selectedIndex].getAttribute('data-due')) || 0;
                prevDueDisplay.innerText = due.toFixed(2);
                
                const statPrevDue = document.getElementById('stat-prev-due');
                if(statPrevDue) statPrevDue.innerText = due.toFixed(2);
                
                stats.classList.remove('hidden');
                calculateTotal();
            } else {
                stats.classList.add('hidden');
                prevDueDisplay.innerText = "0.00";
                calculateTotal();
            }
        }

        function calculateTotal() {
            let total = 0;
            document.querySelectorAll('.item-row').forEach(row => {
                const qty = parseFloat(row.querySelector('.qty-input').value) || 0;
                const price = parseFloat(row.querySelector('.price-input').value) || 0;
                total += qty * price;
            });
            document.getElementById('display-total').innerText = total.toFixed(2);
            document.getElementById('summary-current-bill').innerText = total.toFixed(2);
            
            const prevDue = parseFloat(document.getElementById('summary-prev-due').innerText) || 0;
            const newTotal = prevDue + total;
            document.getElementById('summary-new-total').innerText = newTotal.toFixed(2);

            const currentBillElem = document.getElementById('stat-current-bill');
            if (currentBillElem) {
                currentBillElem.innerText = total.toFixed(2);
                document.getElementById('stat-estimated-total').innerText = newTotal.toFixed(2);
            }
        }

        function addItemRow() {
            const container = document.getElementById('items-container');
            const firstRow = container.querySelector('.item-row');
            const newRow = firstRow.cloneNode(true);
            
            newRow.querySelectorAll('input').forEach(input => {
                input.value = '';
                input.removeAttribute('max');
            });
            newRow.querySelectorAll('select').forEach(select => select.selectedIndex = 0);
            newRow.querySelector('.pack-select').innerHTML = '<option value="">Select...</option>';
            newRow.querySelector('.price-level-select').innerHTML = '<option value="">Select...</option>';
            
             newRow.querySelectorAll('[name]').forEach(el => {
                el.name = el.name.replace(/\[\d+\]/, '[' + itemCount + ']');
            });
            
            // Add event listeners to new row inputs if needed (onchange is inline so it persists)

            container.appendChild(newRow);
            itemCount++;
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\kavishka\Desktop\laravel\bulkLkDeliver\resources\views/sales/billing/index.blade.php ENDPATH**/ ?>