<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            <?php echo e(__('Unload Truck & Verify Goods')); ?> - Delivery #<?php echo e($delivery->id); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <form action="<?php echo e(route('admin.deliveries.unload', $delivery)); ?>" method="POST" class="p-6">
                    <?php echo csrf_field(); ?>
                    
                    <div class="mb-6 p-4 bg-indigo-50 dark:bg-indigo-900/20 rounded-lg border border-indigo-100 dark:border-indigo-800">
                        <h3 class="text-indigo-800 dark:text-indigo-300 font-semibold mb-2">Truck Information</h3>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-sm">
                            <div>
                                <span class="text-gray-500">Truck:</span>
                                <span class="font-medium ml-1"><?php echo e($delivery->vehicle->truck_number); ?></span>
                            </div>
                            <div>
                                <span class="text-gray-500">Sales Rep:</span>
                                <span class="font-medium ml-1"><?php echo e($delivery->salesRep->name); ?></span>
                            </div>
                            <div>
                                <span class="text-gray-500">Started:</span>
                                <span class="font-medium ml-1"><?php echo e($delivery->started_at->format('M d, H:i')); ?></span>
                            </div>
                            <div>
                                <span class="text-gray-500">Ended:</span>
                                <span class="font-medium ml-1"><?php echo e($delivery->ended_at->format('M d, H:i')); ?></span>
                            </div>
                        </div>
                    </div>

                    <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">Verification Checklist</h3>
                    
                    <div class="overflow-x-auto border border-gray-200 dark:border-gray-700 rounded-lg">
                        <table class="w-full text-sm text-left">
                            <thead class="bg-gray-50 dark:bg-gray-700 text-gray-700 dark:text-gray-300 uppercase text-xs">
                                <tr>
                                    <th class="px-6 py-3">Product</th>
                                    <th class="px-6 py-3 text-center">System Recorded Stock (Base Units)</th>
                                    <th class="px-6 py-3 text-center">Physical Goods Unloaded (Base Units)</th>
                                    <th class="px-6 py-3 text-center">Status</th>
                                </tr>
                            </thead>
                            <tbody x-data="{ 
                                physical: {},
                                check(system, phys) {
                                    if (phys === undefined || phys === '') return 'pending';
                                    return system == phys ? 'match' : 'mismatch';
                                }
                            }">
                                <?php $__currentLoopData = $delivery->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="border-b dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700/50">
                                        <td class="px-6 py-4 font-medium text-gray-900 dark:text-white">
                                            <?php echo e($item->product->name); ?>

                                        </td>
                                        <td class="px-6 py-4 text-center font-mono">
                                            <?php echo e($item->system_quantity); ?>

                                        </td>
                                        <td class="px-6 py-4">
                                            <input 
                                                type="number" 
                                                name="physical_quantities[<?php echo e($item->id); ?>][quantity]" 
                                                x-model="physical[<?php echo e($item->id); ?>]"
                                                class="w-32 mx-auto block border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 rounded-md shadow-sm"
                                                required
                                                min="0"
                                            >
                                        </td>
                                        <td class="px-6 py-4 text-center">
                                            <template x-if="check(<?php echo e($item->system_quantity); ?>, physical[<?php echo e($item->id); ?>]) === 'pending'">
                                                <span class="text-gray-400 font-italic">Awaiting...</span>
                                            </template>
                                            <template x-if="check(<?php echo e($item->system_quantity); ?>, physical[<?php echo e($item->id); ?>]) === 'match'">
                                                <span class="text-green-600 dark:text-green-400 font-bold flex items-center justify-center">
                                                    <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path></svg> Match
                                                </span>
                                            </template>
                                            <template x-if="check(<?php echo e($item->system_quantity); ?>, physical[<?php echo e($item->id); ?>]) === 'mismatch'">
                                                <span class="text-red-600 dark:text-red-400 font-bold flex items-center justify-center">
                                                    <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path></svg> Mismatch!
                                                </span>
                                            </template>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-8 bg-yellow-50 dark:bg-yellow-900/20 p-4 border-l-4 border-yellow-400 rounded-r-lg">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm text-yellow-700 dark:text-yellow-400">
                                    Once confirmed, the physical goods will be added back to the warehouse inventory and the truck's stock will be cleared. Any discrepancies will be recorded in the delivery report.
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="mt-8 flex justify-end">
                        <a href="<?php echo e(route('admin.deliveries.index')); ?>" class="mr-4 px-4 py-2 text-gray-700 dark:text-gray-300">Cancel</a>
                        <?php if (isset($component)) { $__componentOriginald411d1792bd6cc877d687758b753742c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald411d1792bd6cc877d687758b753742c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.primary-button','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                            <?php echo e(__('Confirm Unloading & Finalize Trip')); ?>

                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald411d1792bd6cc877d687758b753742c)): ?>
<?php $attributes = $__attributesOriginald411d1792bd6cc877d687758b753742c; ?>
<?php unset($__attributesOriginald411d1792bd6cc877d687758b753742c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald411d1792bd6cc877d687758b753742c)): ?>
<?php $component = $__componentOriginald411d1792bd6cc877d687758b753742c; ?>
<?php unset($__componentOriginald411d1792bd6cc877d687758b753742c); ?>
<?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\kavishka\Desktop\laravel\bulkLkDeliver\resources\views/admin/deliveries/unload.blade.php ENDPATH**/ ?>