<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
                <?php echo e(__('Deliveries & Trips')); ?>

            </h2>
            <a href="<?php echo e(route('admin.deliveries.create')); ?>" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-700 focus:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                New Delivery (Load Truck)
            </a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg border border-gray-200 dark:border-gray-700">
                <div class="px-6 pt-6 pb-0">
                    <div class="border-b border-gray-200 dark:border-gray-700">
                        <nav class="-mb-px flex space-x-8" aria-label="Tabs">
                            <a href="<?php echo e(route('admin.deliveries.index', ['status' => 'all'])); ?>" 
                               class="<?php echo e(!request('status') || request('status') == 'all' ? 'border-indigo-500 text-indigo-600 dark:text-indigo-400' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                All Deliveries
                            </a>
                            <a href="<?php echo e(route('admin.deliveries.index', ['status' => 'ongoing'])); ?>" 
                               class="<?php echo e(request('status') == 'ongoing' ? 'border-indigo-500 text-indigo-600 dark:text-indigo-400' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                🚚 Ongoing (On Trip)
                            </a>
                            <a href="<?php echo e(route('admin.deliveries.index', ['status' => 'loading'])); ?>" 
                               class="<?php echo e(request('status') == 'loading' ? 'border-indigo-500 text-indigo-600 dark:text-indigo-400' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                📦 Loading
                            </a>
                            <a href="<?php echo e(route('admin.deliveries.index', ['status' => 'unloading'])); ?>" 
                               class="<?php echo e(request('status') == 'unloading' ? 'border-indigo-500 text-indigo-600 dark:text-indigo-400' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                📥 Unloading
                            </a>
                            <a href="<?php echo e(route('admin.deliveries.index', ['status' => 'completed'])); ?>" 
                               class="<?php echo e(request('status') == 'completed' ? 'border-indigo-500 text-indigo-600 dark:text-indigo-400' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                ✅ Completed History
                            </a>
                        </nav>
                    </div>
                </div>

                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <div class="overflow-x-auto">
                        <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                                <tr>
                                    <th scope="col" class="px-6 py-3">ID</th>
                                    <th scope="col" class="px-6 py-3">Truck</th>
                                    <th scope="col" class="px-6 py-3">Team</th>
                                    <th scope="col" class="px-6 py-3">Status</th>
                                    <th scope="col" class="px-6 py-3">Timestamps</th>
                                    <th scope="col" class="px-6 py-3">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 transition">
                                        <td class="px-6 py-4 font-medium text-gray-900 dark:text-white">
                                            #<?php echo e($delivery->id); ?>

                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="font-semibold text-indigo-600 dark:text-indigo-400"><?php echo e($delivery->vehicle->truck_number); ?></div>
                                            <div class="text-xs text-gray-400"><?php echo e($delivery->vehicle->vehicle_type ?? 'Truck'); ?></div>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="flex flex-col">
                                                <span class="flex items-center"><svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20"><path d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z"/></svg> <?php echo e($delivery->driver->name); ?> (Driver)</span>
                                                <span class="flex items-center mt-1"><svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20"><path d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z"/></svg> <?php echo e($delivery->salesRep->name); ?> (Rep)</span>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4">
                                            <?php
                                                $statusClasses = [
                                                    'pending' => 'bg-gray-100 text-gray-800',
                                                    'loading' => 'bg-blue-100 text-blue-800',
                                                    'ongoing' => 'bg-yellow-100 text-yellow-800',
                                                    'unloading' => 'bg-purple-100 text-purple-800',
                                                    'completed' => 'bg-green-100 text-green-800',
                                                ];
                                            ?>
                                            <span class="px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($statusClasses[$delivery->status]); ?>">
                                                <?php echo e(ucfirst($delivery->status)); ?>

                                            </span>
                                        </td>
                                        <td class="px-6 py-4 text-xs">
                                            <?php if($delivery->started_at): ?>
                                                <div>Start: <?php echo e($delivery->started_at->format('M d, H:i')); ?></div>
                                            <?php endif; ?>
                                            <?php if($delivery->ended_at): ?>
                                                <div class="mt-1">End: <?php echo e($delivery->ended_at->format('M d, H:i')); ?></div>
                                            <?php endif; ?>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="flex space-x-2">
                                                <a href="<?php echo e(route('admin.deliveries.show', $delivery)); ?>" class="text-blue-600 hover:text-blue-900 dark:text-blue-400 dark:hover:text-blue-300">View</a>
                                                
                                                <?php if($delivery->status === 'loading'): ?>
                                                    <form action="<?php echo e(route('admin.deliveries.start', $delivery)); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" class="text-green-600 hover:text-green-900 font-semibold">Start Delivery</button>
                                                    </form>
                                                <?php elseif($delivery->status === 'ongoing'): ?>
                                                    <form action="<?php echo e(route('admin.deliveries.end', $delivery)); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" class="text-red-600 hover:text-red-900 font-semibold">End Delivery</button>
                                                    </form>
                                                <?php elseif($delivery->status === 'unloading'): ?>
                                                    <a href="<?php echo e(route('admin.deliveries.unload-form', $delivery)); ?>" class="text-purple-600 hover:text-purple-900 font-semibold">Unload & Verify</a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="px-6 py-10 text-center text-gray-500 italic">
                                            No deliveries found. Start by loading a truck.
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        <?php echo e($deliveries->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\kavishka\Desktop\laravel\bulkLkDeliver\resources\views/admin/deliveries/index.blade.php ENDPATH**/ ?>