<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Payroll Details')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex justify-between items-start mb-6">
                        <div>
                            <h3 class="text-2xl font-bold"><?php echo e($user->name); ?></h3>
                            <p class="text-gray-600"><?php echo e(\Carbon\Carbon::parse($payroll->month)->format('F Y')); ?></p>
                            <p class="text-sm text-gray-500">Payment Date: <?php echo e($payroll->payment_date->format('M d, Y')); ?></p>
                        </div>
                        <span class="px-3 py-1 rounded-full text-sm
                            <?php echo e($payroll->status === 'paid' ? 'bg-green-100 text-green-800' : 
                               ($payroll->status === 'processed' ? 'bg-blue-100 text-blue-800' : 'bg-yellow-100 text-yellow-800')); ?>">
                            <?php echo e(ucfirst($payroll->status)); ?>

                        </span>
                    </div>

                    <div class="grid grid-cols-2 gap-6 mb-6">
                        <div class="bg-gray-50 p-4 rounded">
                            <h4 class="font-semibold mb-3">My Information</h4>
                            <div class="space-y-2 text-sm">
                                <div><strong>EPF Number:</strong> <?php echo e($user->epf_number ?? 'Not Set'); ?></div>
                                <div><strong>ETF Number:</strong> <?php echo e($user->etf_number ?? 'Not Set'); ?></div>
                                <div><strong>Email:</strong> <?php echo e($user->email); ?></div>
                            </div>
                        </div>

                        <div class="bg-gray-50 p-4 rounded">
                            <h4 class="font-semibold mb-3">Bank Information</h4>
                            <div class="space-y-2 text-sm">
                                <div><strong>Bank:</strong> <?php echo e($user->bank_name ?? 'Not Set'); ?></div>
                                <div><strong>Account:</strong> <?php echo e($user->bank_account_number ?? 'Not Set'); ?></div>
                                <div><strong>Branch:</strong> <?php echo e($user->bank_branch ?? 'Not Set'); ?></div>
                            </div>
                            <a href="<?php echo e(route('sales.my-profile')); ?>" class="text-xs text-blue-600 hover:text-blue-800 mt-2 inline-block">
                                Update Bank Details
                            </a>
                        </div>
                    </div>

                    <div class="border-t pt-6">
                        <h4 class="font-semibold mb-4">Salary Breakdown</h4>
                        
                        <table class="w-full">
                            <tr class="border-b">
                                <td class="py-2">Basic Salary</td>
                                <td class="py-2 text-right">Rs. <?php echo e(number_format($payroll->basic_salary, 2)); ?></td>
                            </tr>
                            <tr class="border-b">
                                <td class="py-2">Commission Earned</td>
                                <td class="py-2 text-right">Rs. <?php echo e(number_format($payroll->total_commission, 2)); ?></td>
                            </tr>
                            <tr class="border-b bg-gray-50 font-semibold">
                                <td class="py-2">Gross Salary</td>
                                <td class="py-2 text-right">Rs. <?php echo e(number_format($payroll->gross_salary, 2)); ?></td>
                            </tr>
                            <tr class="border-b">
                                <td class="py-2 text-red-600">EPF Contribution (8%)</td>
                                <td class="py-2 text-right text-red-600">- Rs. <?php echo e(number_format($payroll->epf_employee, 2)); ?></td>
                            </tr>
                            <tr class="border-b">
                                <td class="py-2 text-red-600">ETF Contribution (3%)</td>
                                <td class="py-2 text-right text-red-600">- Rs. <?php echo e(number_format($payroll->etf_employee, 2)); ?></td>
                            </tr>
                            <?php if($payroll->salary_advance_deduction > 0): ?>
                            <tr class="border-b">
                                <td class="py-2 text-red-600">Salary Advance Deduction</td>
                                <td class="py-2 text-right text-red-600">- Rs. <?php echo e(number_format($payroll->salary_advance_deduction, 2)); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if($payroll->loan_deduction > 0): ?>
                            <tr class="border-b">
                                <td class="py-2 text-red-600">Loan Installment</td>
                                <td class="py-2 text-right text-red-600">- Rs. <?php echo e(number_format($payroll->loan_deduction, 2)); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if($payroll->other_deductions > 0): ?>
                            <tr class="border-b">
                                <td class="py-2 text-red-600">Other Deductions</td>
                                <td class="py-2 text-right text-red-600">- Rs. <?php echo e(number_format($payroll->other_deductions, 2)); ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr class="border-b bg-gray-50 font-semibold">
                                <td class="py-2 text-red-600">Total Deductions</td>
                                <td class="py-2 text-right text-red-600">- Rs. <?php echo e(number_format($payroll->total_deductions, 2)); ?></td>
                            </tr>
                            <tr class="bg-green-50 font-bold text-lg">
                                <td class="py-3 text-green-700">Net Salary (Take Home)</td>
                                <td class="py-3 text-right text-green-700">Rs. <?php echo e(number_format($payroll->net_salary, 2)); ?></td>
                            </tr>
                        </table>
                    </div>

                    <div class="border-t mt-6 pt-6 bg-blue-50 p-4 rounded">
                        <h4 class="font-semibold mb-4 text-blue-900">Employer Contributions (For Your Information)</h4>
                        <p class="text-sm text-blue-800 mb-3">Your employer contributes the following amounts to your EPF/ETF on your behalf:</p>
                        <table class="w-full">
                            <tr class="border-b border-blue-200">
                                <td class="py-2 text-blue-900">EPF (Employer 12%)</td>
                                <td class="py-2 text-right text-blue-900">Rs. <?php echo e(number_format($payroll->epf_employer, 2)); ?></td>
                            </tr>
                            <tr class="border-b border-blue-200">
                                <td class="py-2 text-blue-900">ETF (Employer 3%)</td>
                                <td class="py-2 text-right text-blue-900">Rs. <?php echo e(number_format($payroll->etf_employer, 2)); ?></td>
                            </tr>
                            <tr class="font-semibold">
                                <td class="py-2 text-blue-900">Total Employer Contribution</td>
                                <td class="py-2 text-right text-blue-900">Rs. <?php echo e(number_format($payroll->epf_employer + $payroll->etf_employer, 2)); ?></td>
                            </tr>
                        </table>
                        <p class="text-xs text-blue-700 mt-3">
                            * Your total EPF: Rs. <?php echo e(number_format($payroll->epf_employee + $payroll->epf_employer, 2)); ?> (Your 8% + Employer 12%)<br>
                            * Your total ETF: Rs. <?php echo e(number_format($payroll->etf_employee + $payroll->etf_employer, 2)); ?> (Your 3% + Employer 3%)
                        </p>
                    </div>

                    <?php if($payroll->notes): ?>
                    <div class="border-t mt-6 pt-6">
                        <h4 class="font-semibold mb-2">Notes</h4>
                        <p class="text-gray-700"><?php echo e($payroll->notes); ?></p>
                    </div>
                    <?php endif; ?>

                    <div class="mt-6 flex gap-3">
                        <a href="<?php echo e(route('sales.my-salary.index')); ?>" 
                           class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-2 rounded-md">
                            Back to Salary
                        </a>
                        <button onclick="window.print()" 
                                class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-md">
                            Print Payslip
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\kavishka\Desktop\laravel\bulkLkDeliver\resources\views/sales_rep/salary/show.blade.php ENDPATH**/ ?>